% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxFit.R
\name{gtoxFit}
\alias{gtoxFit}
\title{Fit the data with the constant, hill, and gain-loss models}
\usage{
gtoxFit(logc, resp, bmad, force.fit = FALSE, ...)
}
\arguments{
\item{logc}{Numeric, log concentration values}

\item{resp}{Numeric, normalized response values}

\item{bmad}{Numeric, the baseline median absolute deviation for the entire
assay}

\item{force.fit}{Logical, TRUE indicates to attempt fitting every
concentration series}

\item{\dots}{Any other data to be included in list output.}
}
\value{
List of summary values and fit parameters for the given data.
}
\description{
\code{gtoxFit} fits the constant, hill, and gain-loss models to the given 
data and returns some summary statistics and the fit parameters in a list.
}
\details{
By default, \code{gtoxFit} will only attempt to fit concentration series
when at least one median value is greater than 3*bmad.
}
\examples{
logc <- 1:10
resp <- sapply(1:10, gtoxHillVal, ga = 5, tp = 50, gw = 0.5)
params <- gtoxFit(logc = logc, resp = resp, bmad = 10)
plot(resp ~ logc)
gtoxAddModel(pars = params, modl = "hill")

}
\seealso{
\code{\link{gtoxObjCnst}}, \code{\link{gtoxObjHill}},
\code{\link{gtoxObjGnls}}, \code{\link{constrOptim}}
}
