% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glPlotToxInd.R
\name{glPlotToxInd}
\alias{glPlotToxInd}
\title{Plot toxicological indicator values for all chemicals in input}
\usage{
glPlotToxInd(asid, tp = NULL, stat = quote(modl_acc))
}
\arguments{
\item{asid}{assay source id}

\item{tp}{Time point to report}

\item{stat}{statistic to plot}
}
\value{
None
}
\description{
This function plots the toxicological indicator value for
the assay source id in input.
}
\details{
This function is useful to plot toxicological indicator values. These
values, for each chemical, represent an average impact of the chemical
across the list of endpoints tested. The function transform the data to minus
log scale. Hence the larger the indicator value, larger is the impact of the
chemical.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Compute and plot toxicological severity index
glPlotToxInd(asid=1L)

}
