% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glComputeToxInd.R
\name{glComputeToxInd}
\alias{glComputeToxInd}
\title{Create toxicological indicator values for all chemicals in input}
\usage{
glComputeToxInd(asid, tp = NULL, stat = quote(modl_acc))
}
\arguments{
\item{asid}{assay source id}

\item{tp}{Time point to report}

\item{stat}{statistic to plot}
}
\value{
A data.table with toxicological severity index for each chemical.
}
\description{
This function computes the toxicological indicator value for
the assay source id in input.
}
\details{
This function is useful to compute toxicological indicator values. These
values, for each chemical, represent an average impact of the chemical
across the list of endpoints tested. The function transform the data to minus
log scale. Hence the larger the indicator value, larger is the impact of the
chemical.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Compute toxicological severity index
dat <- glComputeToxInd(asid = 1L)
dat[]

}
