% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay_funcs.R, R/gtoxLoadAcid.R,
%   R/gtoxLoadAeid.R, R/gtoxLoadAid.R, R/gtoxLoadAsid.R
\name{Load assay information}
\alias{Load assay information}
\alias{gtoxLoadAcid}
\alias{gtoxLoadAeid}
\alias{gtoxLoadAid}
\alias{gtoxLoadAsid}
\title{Functions for loading assay information}
\usage{
gtoxLoadAcid(fld = NULL, val = NULL, add.fld = NULL)

gtoxLoadAeid(fld = NULL, val = NULL, add.fld = NULL)

gtoxLoadAid(fld = NULL, val = NULL, add.fld = NULL)

gtoxLoadAsid(fld = NULL, val = NULL, add.fld = NULL)
}
\arguments{
\item{fld}{Character, the field(s) to query/subset on}

\item{val}{List, vectors of values for each field to query/subset on. Must 
be in the same order as 'fld'.}

\item{add.fld}{Character, additional field(s) to include, but not query/
subset on}
}
\value{
A data.table containing the ID, name, and any additional fields.
}
\description{
These functions query the gtox databases and returns a data.table with 
assay ID and name information. More information about the assay
hierarchy is available in the overview vignette.
}
\details{
Each element in the assay hierarchy has its own function, loading the ID and
name for the given assay element. For example, \code{gtoxLoadAsid} will 
return the assay source ID (asid) and assay source name (asnm).
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## The load assay functions can be used without any parameters to list the 
## full list of registered assay elements:

## Assay source ID table
gtoxLoadAsid()

## Assay ID table
gtoxLoadAid()

## Assay component ID table
gtoxLoadAcid()

## Assay endpoint ID table
gtoxLoadAeid()

## Similarly, the user can add fields without doing any element selection:
gtoxLoadAeid(add.fld = c("asid", "aid", "acid"))

## Or, the user can look only at a subset:
gtoxLoadAeid(fld = "aeid", val = 1, add.fld = "asid")

## The field can be any value in one of the corresponding assay element
## tables, but the functions also recognize the abbreviated version of
## the name fields.
gtoxListFlds("assay")
a1 <- gtoxLoadAeid(fld = "anm", val = "Apo Necro (casp37)_4h")
a2 <- gtoxLoadAeid(fld = "assay_name", val = "Apo Necro (casp37)_4h")
identical(a1, a2)

## Reset configuration
options(conf_store)

}
