% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpkm_count_conversion.r
\name{countToTpm}
\alias{countToTpm}
\title{Convert count to Tpm}
\usage{
countToTpm(counts_matrix, keyType = "SYMBOL", gene_cov)
}
\arguments{
\item{counts_matrix}{a matrix, colnames of counts_matrix are sample name,
rownames of counts_matrix are gene symbols}

\item{keyType}{keyType, one of keytypes(org.Hs.eg.db).}

\item{gene_cov}{data.frame of two column, the first column is gene length, 
the second column is gene GC content}
}
\value{
a matrix
}
\description{
Convert count to Tpm
}
\examples{
data(gene_cov)
lung_squ_count2 <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), ncol = 3)
rownames(lung_squ_count2) <- c("DISC1", "TCOF1", "SPPL3")
colnames(lung_squ_count2) <- c("sample1", "sample2", "sample3")
result <- countToTpm(lung_squ_count2,
    keyType = "SYMBOL",
    gene_cov = gene_cov
)
}
