% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoisBG.R
\docType{methods}
\name{diagPoisBG}
\alias{diagPoisBG}
\alias{diagPoisBG,NanoStringGeoMxSet-method}
\alias{diagPoisBG,list-method}
\title{Perform diagnosis on Poisson background model}
\usage{
diagPoisBG(object, ...)

\S4method{diagPoisBG}{NanoStringGeoMxSet}(
  object,
  split = FALSE,
  padj = FALSE,
  padj_method = "BH",
  cutoff = 1e-06,
  generate_ppplot = TRUE
)

\S4method{diagPoisBG}{list}(
  object,
  padj = FALSE,
  padj_method = "BH",
  cutoff = 1e-06,
  generate_ppplot = TRUE
)
}
\arguments{
\item{object}{a list of sizefact, featfact, countmat, or id (if it is for mutliple slides)}

\item{...}{additional argument list that might be used}

\item{split}{indicator variable on whether it is for multiple slides (Yes, TRUE; No, FALSE)}

\item{padj}{whether to adjust p value for outlier detection, default =TRUE}

\item{padj_method}{p value adjustment method, default ="BH"}

\item{cutoff}{p value(or adjusted p value) cutoff to determine outliers}

\item{generate_ppplot}{whether to generate ppplot, default =TRUE}
}
\value{
a valid S4 object
\itemize{
  \item lowtail - A matrix of lower tail probabilty, in assay slot
  \item uptail - A matrix of upper tail probability, in assay slot
  \item disper (or disper_sp if non single-valued groupvar is provided) - dispersion parameter in experimenetData
  \item low_outlier - A matrix to indicate lower outliers (0:False, 1:True) in assay slot
  \item upper_outlier - A matrix to indicate upper outliers (0:False, 1:True) in assay slot
}

a list of following items
\itemize{
  \item lowtail - A matrix of lower tail probabilty
  \item uptail - A matrix of upper tail probability
  \item disper - dispersion parameter
  \item outlier - A list of coodinates of lower and upper outliers
}
}
\description{
Perform diagnosis on Poisson background model

Perform diagnosis on Poisson background model
}
\examples{
data(demoData)
demoData <- fitPoisBG(demoData, size_scale = "sum")
demoData <- diagPoisBG(demoData)
Biobase::notes(demoData)$disper
demoData <- fitPoisBG(demoData, groupvar = "slide name")
demoData <- diagPoisBG(demoData, split = TRUE)
Biobase::notes(demoData)$disper_sp
}
