% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findSignature.R
\name{findKeywordInRAV}
\alias{findKeywordInRAV}
\title{Find the rank of your keyword in the RAV's GSEA annotation}
\usage{
findKeywordInRAV(RAVmodel, keyword, ind, n = NULL, includeTotal = TRUE)
}
\arguments{
\item{RAVmodel}{PCAGenomicSignatures-object.}

\item{keyword}{A character vector. If you are searching for multiple keywords
at the same time, use \code{\link{paste}} with \code{collapse="|"} argument.}

\item{ind}{An integer. The RAV number you want to check.}

\item{n}{An integer. The number of top enriched pathways (based on abs(NES))
to search. Under default (\code{NULL}), all the enriched pathways are used.}

\item{includeTotal}{Under the default condition (\code{TRUE}), the total
number of enriched pathways will be also printed out as a part of the output.}
}
\value{
A character containing the rank of keyword-containing pathways
(separated by |), followed by the total number of enriched pathways in
parenthesis.
}
\description{
Once you provide RAVmodel, keyword you're searching for, and the RAV number
to this function, it will give you the abs(NES)-based rank of your keyword in
the enriched pathways of the target RAV. If can be useful to find out how
uniquely your keyword-containing pathways are represented.
}
\examples{
data(miniRAVmodel)
findKeywordInRAV(miniRAVmodel, "Bcell", ind = 695)

}
