% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummaryStats.R
\name{plotInteractionAnnotations}
\alias{plotInteractionAnnotations}
\title{Plot a donut plot of interaction types for an annotated GInteractions object}
\usage{
plotInteractionAnnotations(
  GIObject,
  node.classes = NULL,
  viewpoints = NULL,
  other = 0,
  keep.order = FALSE,
  legend = FALSE
)
}
\arguments{
\item{GIObject}{A GInteractions object}

\item{node.classes}{Optional. All node.classes to include in the analysis.
Default: all node classes.}

\item{viewpoints}{Optional. If set will only consider interactions where at
least one anchor is of this node class. Default: all classes in node.classes.}

\item{other}{Optional. Interaction types making up fewer than 'other' percent
of the total interactions will be consolidated into a single 'other' category.}

\item{keep.order}{Optional. Logical. Keep original order of node.classes for
plotting or not. Default: FALSE, alphabetical order.}

\item{legend}{Optional. Logical. If TRUE, legend is plotted to right of donut
plot. If FALSE, donut plot is annotated with category names.}
}
\value{
A ggplot2 plot
}
\description{
Plot a donut plot of interaction types for an annotated GInteractions object
}
\examples{
library('GenomicRanges')
data(hic_example_data)
data(mm9_refseq_promoters)
mm9_refseq_grl = split(mm9_refseq_promoters, mm9_refseq_promoters$id)
annotateInteractions(hic_example_data, list(promoter=mm9_refseq_grl))
plotInteractionAnnotations(hic_example_data)
}
