% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{getters}
\alias{getters}
\alias{anchorOne}
\alias{anchorTwo}
\alias{interactionCounts}
\alias{annotationFeatures}
\alias{name,GInteractions-method}
\alias{name}
\alias{description,GInteractions-method}
\alias{anchorOne,GInteractions-method}
\alias{anchorTwo,GInteractions-method}
\alias{interactionCounts,GInteractions-method}
\alias{annotationFeatures,GInteractions-method}
\title{Functions to access data held in a GenomicInteractions object.}
\usage{
name(GIObject)

anchorOne(GIObject)

anchorTwo(GIObject)

interactionCounts(GIObject)

annotationFeatures(GIObject)

\S4method{name}{GInteractions}(GIObject)

\S4method{description}{GInteractions}(object)

\S4method{anchorOne}{GInteractions}(GIObject)

\S4method{anchorTwo}{GInteractions}(GIObject)

\S4method{interactionCounts}{GInteractions}(GIObject)

\S4method{annotationFeatures}{GInteractions}(GIObject)
}
\arguments{
\item{GIObject}{A Gnteractions object}

\item{object}{Object, possibly derived from class \code{\link[Biobase]{eSet-class}}.}
}
\value{
For 'anchorOne' and 'anchorTwo', a GRanges. For 'interactionCounts', 
a numeric vector with counts for each interaction in the object. For
  'description' and 'name',  a character vector with
  length 1. For 'annotationFeatures', a character vector of features with
  which the object was previously annotated, or 'NA' if the object is unannotated.
}
\description{
Use these functions to access data stored in each of the slots of a
GenomicInteractions object.
}
\examples{

library(GenomicRanges)

anchor.one = GRanges(c('chr1', 'chr1', 'chr1', 'chr1'), IRanges(c(10, 20, 30, 20), width=5))
anchor.two = GRanges(c('chr1', 'chr1', 'chr1', 'chr2'), IRanges(c(100, 200, 300, 50), width=5))
interaction_counts = sample(1:10, 4)
test <- GenomicInteractions(anchor.one, anchor.two, counts=interaction_counts)

name(test)
description(test)
anchorOne(test)
anchorTwo(test)
interactionCounts(test)
}
