% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\docType{methods}
\name{countsBetweenAnchors}
\alias{countsBetweenAnchors}
\alias{countsBetweenAnchors,GInteractions,GRanges-method}
\title{Summarise interactions between defined anchors}
\usage{
countsBetweenAnchors(x, y, ...)

\S4method{countsBetweenAnchors}{GInteractions,GRanges}(x, y, ignore_overlaps = FALSE, ...)
}
\arguments{
\item{x}{A GInteractions object}

\item{y}{A GenomicRanges object}

\item{...}{Extra parameters to pass to findOverlaps}

\item{ignore_overlaps}{Allow overlapping anchors. Use this when you have
overlapping anchors but be careful with multi-mapping. The 'within' option
can help with this.}
}
\value{
A GInteractions object with annotated counts between anchors
}
\description{
Calculate the number of of paired-end reads mapping between a defined set of
anchors. This function will ignore counts present in the input data.
}
