% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\docType{methods}
\name{asBED,GInteractions-method}
\alias{asBED,GInteractions-method}
\title{Coerce to BED structure}
\usage{
\S4method{asBED}{GInteractions}(x, keep.mcols = FALSE, score = "score", ...)
}
\arguments{
\item{x}{Generally, a tabular object to structure as BED}

\item{keep.mcols}{logical whether to keep non-BED12 columns in final
output (may cause problems with some parsers).}

\item{score}{character, which field to export as 'score' in BED12.
Defaults to 'auto' which will choose score, then counts,
if present, or fill column with zeros.}

\item{...}{Arguments to pass to methods, see \code{\link[rtracklayer]{asBED}}
for details.}
}
\value{
A `GRanges`, with the metadata columns `name`, `blockStarts` and
        `blockSizes` added.
}
\description{
Coerce the structure of an object to one following BED-like
conventions, i.e., with columns for blocks and thick regions.
}
\examples{
data(hic_example_data)
asBED(hic_example_data)
}
