% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicInteractions-class.R
\name{GenomicInteractions}
\alias{GenomicInteractions}
\alias{GenomicInteractions,GRanges,GRanges,numeric-method}
\alias{GenomicInteractions,GInteractions,ANY,ANY-method}
\alias{GenomicInteractions,GInteractions,numeric,ANY-method}
\alias{GenomicInteractions,numeric,numeric,GRanges-method}
\alias{GenomicInteractions,GRanges,GRanges,GenomicRanges_OR_missing-method}
\alias{GenomicInteractions,missing,missing,GenomicRanges_OR_missing-method}
\alias{GenomicInteractions,ANY,ANY,ANY-method}
\title{Function to create a GenomicInteractions object}
\usage{
GenomicInteractions(anchor1, anchor2, counts, ...)

\S4method{GenomicInteractions}{GRanges,GRanges,numeric}(anchor1, anchor2, counts, ...)

\S4method{GenomicInteractions}{GInteractions,ANY,ANY}(anchor1)

\S4method{GenomicInteractions}{GInteractions,numeric,ANY}(anchor1, anchor2)

\S4method{GenomicInteractions}{numeric,numeric,GRanges}(anchor1, anchor2, counts, ...)

\S4method{GenomicInteractions}{GRanges,GRanges,GenomicRanges_OR_missing}(anchor1, anchor2, counts, ...)

\S4method{GenomicInteractions}{missing,missing,GenomicRanges_OR_missing}(anchor1, anchor2, counts, ...)

\S4method{GenomicInteractions}{ANY,ANY,ANY}(anchor1, anchor2, counts, ...)
}
\arguments{
\item{anchor1, anchor2}{GRanges objects.}

\item{counts}{An integer vector, defaults to 1.}

\item{...}{Additional data to be added to mcols}
}
\value{
a GenomicInteractions object
}
\description{
Create GenomicInteractions objects from two GRanges ojects.
}
\examples{

library(GenomicRanges)

anchor.one = GRanges(c('chr1', 'chr1', 'chr1', 'chr1'), IRanges(c(10, 20, 30, 20), width=5))
anchor.two = GRanges(c('chr1', 'chr1', 'chr1', 'chr2'), IRanges(c(100, 200, 300, 50), width=5))
interaction_counts = sample(1:10, 4)
test <- GenomicInteractions(anchor.one, anchor.two, counts=interaction_counts)

}
