% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids.R
\name{ids}
\alias{ids}
\alias{ids.GDCManifest}
\alias{ids.GDCQuery}
\alias{ids.GDCResults}
\alias{ids.GDCResponse}
\title{Get the ids associated with a GDC query or response}
\usage{
ids(x)

\method{ids}{GDCManifest}(x)

\method{ids}{GDCQuery}(x)

\method{ids}{GDCResults}(x)

\method{ids}{GDCResponse}(x)
}
\arguments{
\item{x}{A \code{\link{GDCQuery}} or \code{\link{GDCResponse}} object}
}
\value{
a character vector of all the entity ids
}
\description{
The GDC assigns ids (in the form of uuids) to objects in its database. Those
ids can be used for relationships, searching on the website, and as
unique ids.  All
}
\examples{
# use with a GDC query, in this case for "cases"
ids(cases() |> filter(~ project.project_id == "TCGA-CHOL"))
# also works for responses
ids(response(files()))
# and results
ids(results(cases()))


}
