% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{matrices}
\alias{matrices}
\alias{matrices,MatrixList-method}
\alias{matrices,CodonSeq-method}
\alias{matrices,DNAStringSet_OR_NULL-method}
\title{Get the Coordinate Representation from DNA Sequences on Specified
Abelian Group}
\usage{
matrices(x, ...)

\S4method{matrices}{MatrixList}(x)

\S4method{matrices}{CodonSeq}(x)

\S4method{matrices}{DNAStringSet_OR_NULL}(
  x,
  base_seq = TRUE,
  filepath = NULL,
  cube = "ACGT",
  group = c("Z4", "Z5", "Z64", "Z125", "Z4^3", "Z5^3"),
  start = NA,
  end = NA,
  chr = 1L,
  strand = "+"
)
}
\arguments{
\item{x}{An object from a \code{\link[Biostrings]{DNAStringSet}} or
\code{\link[Biostrings]{DNAMultipleAlignment}} class carrying the DNA
pairwise alignment of two sequences.}

\item{...}{Not in use.}

\item{base_seq}{Logical. Whether to return the base or codon coordinates on
the selected Abelian group. If codon coordinates are requested, then the
number of the DNA bases in the given sequences must be multiple of 3.}

\item{filepath}{A character vector containing the path to a file in
\emph{\strong{fasta}} format to be read. This argument must be given if
\emph{codon & base} arguments are not provided.}

\item{cube}{A character string denoting one of the 24 Genetic-code cubes,
as given in references (2-3).}

\item{group}{A character string denoting the group representation for the
given base or codon as shown in reference (1).}

\item{start, end, chr, strand}{Optional parameters required to build a
\code{\link[GenomicRanges]{GRanges-class}}. If not provided the default
values given for the function definition will be used.}
}
\value{
The a list of vectors (group = c("Z4", "Z5", "Z64", "Z125") or a
list of matrices (group = ("Z4^3", "Z5^3")) carrying the coordinate
representation on the specified Abelian group.
}
\description{
Extract the Coordinate Representation from DNA Sequences on
Specified Abelian Group.
}
\details{
These are alternative ways to get the list of matrices of base/codon
coordinate and the information on the codon sequence from
\code{\link{CodonSeq}} and \code{\link{MatrixList}} class objects. These
functions can either take the output from functions \code{\link{base_coord}}
and \code{\link{matrices}}  or to operate directly on a
\code{\link[Biostrings]{DNAStringSet}} or to retrieve the a DNA sequence
alignment from a file.

\emph{\strong{base_seq}} parameter will determine whether to return the
matrices of coordinate for a DNA or codon sequence. While in function
\code{\link{seqranges}}, \emph{\strong{granges}} parameter will determine
whether to return a \code{\link[GenomicRanges]{GRanges-class}} object or a
\code{\link[S4Vectors]{DataFrame}}.
}
\examples{
## Load a pairwise alignment
data("aln", package = "GenomAutomorphism")
aln

## Coordinate representation of the aligned sequences on "Z4".
## A list of vectors
matrices(
    x = aln,
    base_seq = TRUE,
    filepath = NULL,
    cube = "ACGT",
    group = "Z4",
)

## Coordinate representation of the aligned sequences on "Z4".
## A list of matrices
matrices(
    x = aln,
    base_seq = FALSE,
    filepath = NULL,
    cube = "ACGT",
    group = "Z5^3",
)
}
\references{
\enumerate{
\item Robersy Sanchez, Jesus Barreto (2021) Genomic Abelian Finite
Groups.
\href{https://doi.org/10.1101/2021.06.01.446543}{doi: 10.1101/2021.06.01.446543}
\item M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
algebraic representations of the standard genetic code in six or in three
dimensions, Adv. Stud. Biol. 4 (2012) 119-152.\href{https://is.gd/na9eap}{PDF}.
\item R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
Comput. Chem. 79 (2018) 527-560.
}
}
\seealso{
\href{https://github.com/genomaths/GenomeAlgebra_SymmetricGroup}{Symmetric Group of the Genetic-Code Cubes.}
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
