% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_simplify.R
\name{gs_simplify}
\alias{gs_simplify}
\title{Simplify results from functional enrichment analysis}
\usage{
gs_simplify(res_enrich, gs_overlap = 0.75)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{gs_overlap}{Numeric value, which defines the threshold for removing
terms that present an overlap greater than the specified value. Changing its
value can control the granularity of how redundant terms are removed from the
original \code{res_enrich} for the next steps, e.g. plotting this via \code{\link[=gs_volcano]{gs_volcano()}}}
}
\value{
A \code{data.frame} with a subset of the original gene sets
}
\description{
Simplify results from functional enrichment analysis, removing genesets that
are redundant to enhance interpretation of the results
}
\examples{

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)

dim(res_enrich)
res_enrich_simplified <- gs_simplify(res_enrich)
dim(res_enrich_simplified)
# and then use this further for all other functions expecting a res_enrich
}
\seealso{
\code{\link[=gs_volcano]{gs_volcano()}} and \code{\link[=ggs_graph]{ggs_graph()}} can e.g. show an overview on the
simplified table of gene sets
}
