% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_mds.R
\name{gs_mds}
\alias{gs_mds}
\title{Multi Dimensional Scaling plot for gene sets}
\usage{
gs_mds(
  res_enrich,
  res_de,
  annotation_obj,
  gtl = NULL,
  n_gs = nrow(res_enrich),
  gs_ids = NULL,
  similarity_measure = "kappa_matrix",
  mds_k = 2,
  mds_labels = 0,
  mds_colorby = "z_score",
  gs_labels = NULL,
  plot_title = NULL,
  return_data = FALSE
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{res_de}{A \code{DESeqResults} object.}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be included (from the top ranked ones). Defaults to the number of rows of
\code{res_enrich}}

\item{gs_ids}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be included, additionally to
the ones specified via \code{n_gs}. Defaults to NULL.}

\item{similarity_measure}{Character, currently defaults to \code{kappa_matrix}, to
specify how to compute the similarity measure between gene sets}

\item{mds_k}{Integer value, number of dimensions to compute in the multi
dimensional scaling procedure}

\item{mds_labels}{Integer, defines the number of labels to be plotted on top
of the scatter plot for the provided gene sets.}

\item{mds_colorby}{Character specifying the column of \code{res_enrich} to be used
for coloring the plotted gene sets. Defaults sensibly to \code{z_score}.}

\item{gs_labels}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be labeled.}

\item{plot_title}{Character string, used as title for the plot. If left \code{NULL},
it defaults to a general description of the plot and of the DE contrast}

\item{return_data}{Logical, whether the function should just return the
data.frame of the MDS coordinates, related to the original \code{res_enrich}
object. Defaults to FALSE.}
}
\value{
A \code{ggplot} object
}
\description{
Multi Dimensional Scaling plot for gene sets, extracted from a \code{res_enrich}
object
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

gs_mds(res_enrich,
  res_de,
  anno_df,
  n_gs = 200,
  mds_labels = 10
)
}
\seealso{
\code{\link[=create_kappa_matrix]{create_kappa_matrix()}} is used to calculate the similarity between
gene sets
}
