% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneTonic-extras.R
\name{export_to_sif}
\alias{export_to_sif}
\title{Export to sif}
\usage{
export_to_sif(g, sif_file = "", edge_label = "relates_to")
}
\arguments{
\item{g}{An \code{igraph} object}

\item{sif_file}{Character string, the path to the file where to save the exported
graph as .sif file}

\item{edge_label}{Character string, defining the name of the interaction type.
Defaults here to "relates_to"}
}
\value{
Returns the path to the exported file, invisibly
}
\description{
Export a graph to a Simple Interaction Format file
}
\examples{
library("igraph")
g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1, 6, 1, 11, 6, 11))
export_to_sif(g, tempfile())
}
