% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverlapFunctions.R
\name{addBroadTypes}
\alias{addBroadTypes}
\title{Change transcript biotypes to a broader set}
\usage{
addBroadTypes(gtf)
}
\arguments{
\item{gtf}{GRanges object of the GTF}
}
\value{
GRanges object of the GTF with new transcript types
}
\description{
Change transcript biotypes to a broader set in a GRanges GTF object
}
\examples{
gtfFile <- system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools")
gtf <- rtracklayer::import(gtfFile)
gtf <- addBroadTypes(gtf)
}
\seealso{
Other gtf manipulation: \code{\link{UTR2UTR53}},
  \code{\link{exonsToTranscripts}},
  \code{\link{filterGtfOverlap}},
  \code{\link{removeDuplicateTranscripts}},
  \code{\link{removeSameExon}},
  \code{\link{reorderExonNumbers}}
}
\author{
Beth Signal
}
