% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkFromGenes.R
\name{networkFromGenes}
\alias{networkFromGenes}
\title{Build network by a list of given genes}
\usage{
networkFromGenes(genes, interactionmap, level = 3, unrooted = FALSE)
}
\arguments{
\item{genes}{A vector of character for interested genes.}

\item{interactionmap}{Transcription regulatory map. 
Column names of interactionmap must be 'from','to'}

\item{level}{Depth of node path}

\item{unrooted}{Return unrooted regulatory network table or not.}
}
\value{
a list with elements:
 rootgene: The nodes with maximal connections.
 sifNetwork: Transcription regulatory network table.
}
\description{
By providing a list of given genes, build a network for input of filterNetwork.
}
\examples{
data("ce.interactionmap")
data("example.data")
genes <- as.character(example.data$ce.bind$from)
xx<-networkFromGenes(example.data$ce.bind, ce.interactionmap, level=2)
}
\keyword{network}
