% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ideoView.R
\name{ideoView}
\alias{ideoView}
\title{Construct an ideogram}
\usage{
ideoView(
  x,
  chromosome = "chr1",
  txtAngle = 45,
  txtSize = 5,
  plotLayer = NULL,
  out = "plot"
)
}
\arguments{
\item{x}{Object of class data frame with rows representing cytogenetic bands.
The data frame must contain the following column names "chrom", "chromStart",
"chromEnd", "name", "gieStain"}

\item{chromosome}{Character string specifying which chromosome from the
"chrom" column in the argument supplied to parameter x to plot.}

\item{txtAngle}{Integer specifying the angle of text labeling cytogenetic
bands.}

\item{txtSize}{Integer specifying the size of text labeling cytogenetic
bands.}

\item{plotLayer}{additional ggplot2 layers for the ideogram}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}
}
\value{
One of the following, a list of dataframes containing data to be
plotted, a grob object, or a plot.
}
\description{
Given a data frame with cytogenetic information, construct an ideogram.
}
\details{
ideoView is a function designed to plot cytogenetic band
inforamtion. Modifications to the graphic object can be made via the
`plotLayer` parameter, see vignette for details.
}
\examples{
# Obtain cytogenetic information for the genome of interest from attached
# data set cytoGeno
data <- cytoGeno[cytoGeno$genome == 'hg38',]

# Call ideoView for chromosome 1
ideoView(data, chromosome='chr1', txtSize=4)
}
