% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covBars.R
\name{covBars}
\alias{covBars}
\title{Construct an overall coverage cohort plot}
\usage{
covBars(
  x,
  colour = NULL,
  plot_title = NULL,
  x_title_size = 12,
  y_title_size = 12,
  facet_lab_size = 10,
  plotLayer = NULL,
  out = "plot"
)
}
\arguments{
\item{x}{Object of class matrix with rows representing the sequencing depth
(i.e. number of reads) and columns corresponding to each sample in the cohort
and elements of the matrix}

\item{colour}{Character vector specifying colours to represent sequencing
depth.}

\item{plot_title}{Character string specifying the title to display on the
plot.}

\item{x_title_size}{Integer specifying the size of the x-axis title.}

\item{y_title_size}{Integer specifying the size of the y-axis title.}

\item{facet_lab_size}{Integer specifying the size of the faceted labels
plotted.}

\item{plotLayer}{Valid ggplot2 layer to be added to the plot.}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}
}
\value{
One of the following, a list of dataframes containing data to be
plotted, a grob object, or a plot.
}
\description{
Given a matrix construct a plot to display sequencing depth acheived
as percentage bars for a cohort of samples.
}
\examples{
# Create data
x <- matrix(sample(100000,500), nrow=50, ncol=10, dimnames=list(0:49,paste0("Sample",1:10)))

# Call plot function
covBars(x)
}
