% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFeatureVectorForScoringBulge.R
\name{buildFeatureVectorForScoringBulge}
\alias{buildFeatureVectorForScoringBulge}
\title{Build Feature Vector For Scoring Offtargets with Bulge}
\usage{
buildFeatureVectorForScoringBulge(
  alns,
  gRNA.size = 20,
  canonical.PAM = "NGG",
  subPAM.start = 2,
  subPAM.end = 3,
  insertion.symbol = "^",
  PAM.size = 3,
  PAM.location = "3prime"
)
}
\arguments{
\item{alns}{alignments, output from getAlnWithBulge
(see the example below)}

\item{gRNA.size}{Size of the gRNA, default to 20L}

\item{canonical.PAM}{PAM sequence, default to NGG}

\item{subPAM.start}{start of the subPAM, default to 2L for NGG}

\item{subPAM.end}{End of the subPAM, default to 3L for NGG}

\item{insertion.symbol}{Symbol used to indicate bulge in DNA
Default to ^}

\item{PAM.size}{Size of the PAM, default to 3L for NGG}

\item{PAM.location}{The location of the PAM, default to 3prime}
}
\description{
Build Feature Vector For Scoring Offtargets with Bulge
}
\examples{

if (interactive())
{
  library(BSgenome.Hsapiens.UCSC.hg19)
  library(GUIDEseq)
  peaks.f <- system.file("extdata", "T2plus100OffTargets.bed",
     package = "GUIDEseq")
  gRNA <- "GACCCCCTCCACCCCGCCTC"
  temp <- GUIDEseq:::getAlnWithBulge(gRNA, gRNA.name = "T2",
      peaks = peaks.f, BSgenomeName = Hsapiens,
       peaks.withHeader = TRUE)
   fv <- buildFeatureVectorForScoringBulge(temp$aln.indel)
   fv$featureVectors
 }
}
\author{
Lihua Julie Zhu
}
