% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-functions.R
\name{callback_base_return_pop}
\alias{callback_base_return_pop}
\title{A base callback function that returns a galgo.Obj}
\usage{
callback_base_return_pop (userdir = "",generation, pop_pool, 
pareto, prob_matrix, current_time)
}
\arguments{
\item{userdir}{the default directory used by `galgo()` to store files}

\item{generation}{a number indicating the number of iterations of the galgo 
algorithm}

\item{pop_pool}{a \code{data.frame} with the solution vectors, number of 
clusters and their ranking.}

\item{pareto}{the solutions found by Galgo across all generations in the 
solution space}

\item{prob_matrix}{a \code{matrix} or \code{data.frame}. Must be an 
expression matrix with features in rows and samples in columns}

\item{current_time}{an \code{POSIXct} object}
}
\value{
an object of class galgo
}
\description{
A base callback function that returns a galgo.Obj
}
\examples{
# load example dataset

library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)
expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)
# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo with base_return_pop_callback assigned to the end_galgo_callback
# hook-point
# By using this callback galgo() return a `galgo,Obj` object.
output <- GSgalgoR::galgo(generations = 5,
population = 15,
prob_matrix = expression,
OS = OS,
end_galgo_callback = callback_base_return_pop
)


}
