% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{initializeGRN}
\alias{initializeGRN}
\title{Create and initialize an empty \code{\linkS4class{GRN}} object.}
\usage{
initializeGRN(objectMetadata = list(), outputFolder = ".", genomeAssembly)
}
\arguments{
\item{objectMetadata}{List. Default \code{list()}. Optional (named) list with an arbitrary number of elements, all of which 
capture metadata for the object. \strong{Only atomic data types are allowed for each list element
(see ?is.atomic for more help: logical, integer, numeric, complex, character, raw, and NULL), and this slot is not supposed to store real data}. This is mainly used to distinguish GRN objects from one another by storing object-specific metadata along with the data.}

\item{outputFolder}{Output folder, either absolute or relative to the current working directory. Default \code{"."}. 
Default output folder where all pipeline output will be put unless specified otherwise. We recommend specifying an absolute path. 
Note that for Windows-based systems, the path must be correctly specified with "/" as path separator.}

\item{genomeAssembly}{Character. No default. The genome assembly of all data that to be used within this object. 
Currently, supported genomes are: \code{hg19}, \code{hg38}, \code{mm9}, \code{mm10}, \code{mm39}, \code{rn6}, \code{rn7}, \code{dm6}. If you need additional genomes, let us know. See function description for further information and notes.}
}
\value{
Empty \code{\linkS4class{GRN}} object
}
\description{
Executing this function is the very first step in the *GRaNIE* workflow. After its execution, data can be added to the object.
}
\examples{
meta.l = list(name = "exampleName", date = "01.03.22")
GRN = initializeGRN(objectMetadata = meta.l, outputFolder = "output", genomeAssembly = "hg38")
}
