% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{addSNPData}
\alias{addSNPData}
\title{Add SNP data to a \code{\linkS4class{GRN}} object and associate SNPs to peaks.}
\usage{
addSNPData(
  GRN,
  SNP_IDs,
  EnsemblVersion = NULL,
  add_SNPs_LD = FALSE,
  requeryLD = FALSE,
  population = "CEU",
  r2d = "r2",
  token = NULL,
  filter = "R2 > 0.8",
  forceRerun = FALSE
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{SNP_IDs}{Character vector. No default. Vector of SNP IDs (rsID) that should be integrated and overlapped with the peaks.}

\item{EnsemblVersion}{\code{NULL} or Character(1). Default \code{NULL}. Only relevant if \code{source} is not set to \code{custom}, ignored otherwise. The Ensembl version to use for the retrieval of gene IDs from their provided database names (e.g., JASPAR) via \code{biomaRt}.
By default (\code{NULL}), the newest version is selected for the most recent genome assembly versions is used (see \code{biomaRt::listEnsemblArchives()} for supported versions). This parameter can override this to use a custom (older) version instead.}

\item{add_SNPs_LD}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Should SNPs in LD with any of the user-provided SNPs that overlap a peak be identified and added to the peak? 
If set to \code{TRUE}, \code{LDlinkR::LDproxy_batch} will be used to identify SNPs in LD based on the 
user-provided \code{SNP_IDs} argument, a specific (set of) populations (argument \code{population}) and a value for \code{r2d}.
The full table (stored in \code{GRN@annotation$SNPs}) is then subsequently filtered, see also the \code{filter} argument.}

\item{requeryLD}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Only applicable if \code{add_SNPs_LD = TRUE} and ignored otherwise.
Should \code{LDlinkR::LDproxy_batch} be re-executed if already present? As this
is very time-consuming, querying the database is only performed if this parameter is set to \code{TRUE} or if \code{GRN@annotation$SNPs} is missing.}

\item{population}{Character vector. Default \code{CEU}. Only applicable if \code{add_SNPs_LD = TRUE} and ignored otherwise.
Population code(s) from the 1000 Genomes project to be used for \code{LDlinkR::LDproxy_batch}.
Multiple codes are allowed. For all valid codes, see \url{https://ftp.1000genomes.ebi.ac.uk/vol1/ftp/README_populations.md}}

\item{r2d}{\code{r2} or \code{d}. Default \code{r2}. Only applicable if \code{add_SNPs_LD = TRUE} and ignored otherwise.
See the help of the function \code{LDlinkR::LDproxy_batch} for more details.}

\item{token}{Character or \code{NULL}. Default \code{NULL}. Only applicable if \code{add_SNPs_LD = TRUE} and ignored otherwise. 
\code{LDlink} provided user token. Register for token at https://ldlink.nih.gov/?tab=apiaccess. 
Has to be done only once and is very simple and straight forward but unfortunately necessary. An example, non-functional token is \code{2c49a3b54g04}.}

\item{filter}{Character. Default \code{R2 > 0.8}. Only applicable if \code{add_SNPs_LD = TRUE} and ignored otherwise.
Filter criteria for the output table as generated by \code{LDlinkR::LDproxy_batch}.
\code{dplyr::filter} style is used to specify filters, and multiple filtering criteria can be used (e.g., \code{R2 > 0.8 & MAF > 0.01}).
The filtered table is stored in \code{GRN@annotation$SNPs_filtered}. Note that re-filtering is quick without the need to re-query the database unless \code{requeryLD = TRUE}.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with additional information added from this function.
}
\description{
This function accepts a vector of SNP IDs (rsID), retrieves their genomic positions and 
overlaps them with the peaks to extend the peak metadata (`GRN@data$peaks$counts_metadata`) by storing the number, positions and rsids of all
overlapping SNPs per peak  (new columns starting with `SNP_`). 
Optionally, SNPs in LD with the user-provided SNPs can be identified using the \code{LDlinkR} package. Note that only SNPs in LD are associated with a peak for those SNPs directly overlapping a peak. 
That is, if a user-provided SNP does not overlap with any peak, neither the SNP itself nor any of the SNPs in LD will be associated with any peak, even if an LD SNP overlaps another peak.
The results of are stored in \code{GRN@annotation$SNPs} (full, unfiltered table) and \code{GRN@annotation$SNPs_filtered} (filtered table), 
and rapid re-filtering is possible without re-querying the database (time-consuming)
}
\details{
`biomaRt` is used to retrieve genomic positions for the user-defined SNPs, which can take a long time depending
on the number of SNPs provided. Similarly, querying the \code{LDlink} servers may take a long time.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = addSNPData(GRN, SNP_IDs = c("rs7570219", "rs6445264", "rs12067275"), forceRerun = FALSE)
}
