% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{build_module}
\alias{build_module}
\title{Fit a regression tree.}
\usage{
build_module(X, Y, max_depth, cor_cutoff, min_divide_size)
}
\arguments{
\item{X}{A n by p matrix as input.}

\item{Y}{A n by q matrix as response.}

\item{max_depth}{Maximum depth of the tree.}

\item{cor_cutoff}{Cutoff for within group Pearson correlation coefficient, if all data belong to a node 
have average correlation greater or equal to this, the node would not split anymore.}

\item{min_divide_size}{Minimum number of data belong to a node allowed for further split of the node.}
}
\value{
A matrix for sample informatrion for each partition level. First column is feature index used 
by the node and second is the value used to split, the rest of the columns are the split of sample: 0 means 
less or equal, 1 means greater and -1 means the sample does not belong to this node.
}
\description{
Fit a regression tree based on Gaussian Likelihood score. Provided in case the best split
is not applicable for R dnorm() function.
}
\examples{
build_module(X = matrix(rnorm(5*10),5,10), Y = matrix(rnorm(5*10),5,10),
                         max_depth=3,cor_cutoff=0.9,min_divide_size=3)
}
