% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEM_model.R
\name{GEM_Gmodel}
\alias{GEM_Gmodel}
\title{GEM_Gmodel Analysis}
\usage{
GEM_Gmodel(snp_file_name, covariate_file_name, methylation_file_name, Gmodel_pv,
  output_file_name)
}
\arguments{
\item{snp_file_name}{Text file with rows representing genotype encoded as 1,2,3 or any three distinct values for major allele homozygote (AA), heterozygote (AB) and minor allele homozygote (BB) and columns representing samples, such as the example data file "snp.txt".}

\item{covariate_file_name}{Text file with rows representing covariate factors and columns representing samples, such as the example data file "cov.txt".}

\item{methylation_file_name}{Text file with rows representing methylation profiles for CpGs, and columns representing samples,  such as the example data file "methylation.txt".}

\item{Gmodel_pv}{The pvalue cut off. Associations with significances at Gmodel_pv level or below are saved to output_file_name, with corresponding estimate of effect size (slope coefficient), test statistics and p-value. Default value is 5.0E-08.}

\item{output_file_name}{The result file with each row presenting a CpG and its association with SNP, which contains CpGID, SNPID, estimate of effect size (slope coefficient), test statistics, pvalue and FDR at each column.}
}
\value{
save results automatically
}
\description{
GEM_Gmodel creates a methQTL genome-wide map.
}
\details{
GEM_Gmodel creates a methQTL genome-wide map by performing matrix based iterative correlation and memory-efficient 
data analysis instead of millions of linear regressions (N = number_of_CpGs x number_of_SNPs)
between methylation and genotyping. Polymorphisms close to CpGs in the same chromosome (cis-) or different chromosome (trans-)
often form methylation quantitative trait loci (methQTLs) with CpGs. In GEM_Gmodel, MethQTLs can be discovered by correlating
single nucleotide polymorphism (SNP) data with CpG methylation from the same samples, by linear regression lm (M ~ G + covt),
where M is a matrix with methylation data, G is a matrix with genotype data and covt is a matrix with covariates,
and all read from the formatted text data file. The methylation data are the measurements for CpG probes, for example,
450,000 CpGs from Illumina Infinium HumanMethylation450 Array. The genotype data are encoded as 1,2,3 or any three 
distinct values for major allele homozygote (AA),
heterozygote (AB) and minor allele homozygote (BB). The linear regression is adjusted by covariates read from covariate data file.
The output of GEM_Gmodel is a list of CpG-SNP pairs, where the SNP is the best fit to explain the particular CpG. The significant
association between CpG-SNP pair suggests the methylation driven by genotyping variants, which is so called methylation quantitative
trait loci (methQTL).
}
\examples{
DATADIR = system.file('extdata',package='GEM')
RESULTDIR = getwd()
snp_file = paste(DATADIR, "snp.txt", sep = .Platform$file.sep)
covariate_file = paste(DATADIR, "cov.txt", sep = .Platform$file.sep)
methylation_file = paste(DATADIR, "methylation.txt", sep = .Platform$file.sep)
Gmodel_pv = 1e-04
output_file = paste(RESULTDIR, "Result_Gmodel.txt", sep = .Platform$file.sep)
GEM_Gmodel(snp_file, covariate_file, methylation_file, Gmodel_pv, output_file)
}

