% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEM_model.R
\name{GEM_Emodel}
\alias{GEM_Emodel}
\title{GEM_Emodel Analysis}
\usage{
GEM_Emodel(env_file_name, covariate_file_name, methylation_file_name, Emodel_pv,
  output_file_name, qqplot_file_name, savePlot = TRUE)
}
\arguments{
\item{env_file_name}{Text file with rows representing environment factor and columns representing samples, such as the example data file "env.txt".}

\item{covariate_file_name}{Text file with rows representing covariate factors and columns representing samples, such as the example data file "cov.txt".}

\item{methylation_file_name}{Text file with rows representing methylation profiles for CpGs, and columns representing samples,  such as the example data file "methylation.txt".}

\item{Emodel_pv}{The pvalue cut off. Associations with significances at Emodel_pv level or below are saved to output_file_name, with corresponding estimate of effect size (slope coefficient), test statistics and p-value. Default value is 1.0.}

\item{output_file_name}{The result file with each row presenting a CpG and its association with environment, which contains CpGID, estimate of effect size (slope coefficient), test statistics, pvalue and FDR at each column.}

\item{qqplot_file_name}{Image file name to present the QQ-plot for all p-value distribution.}

\item{savePlot}{If save the plot.}
}
\value{
save results automatically
}
\description{
GEM_Emodel is to find the association between methylation and environmental factor genome widely.
}
\details{
GEM_Emodel finds the association between methylation and environment genome-wide by performing matrix 
based iterative correlation and memory-efficient data analysis instead of millions of linear regressions 
(N = number_of_CpGs). The methylation data are the measurements for CpG probes, for example, 450,000 CpGs 
from Illumina Infinium HumanMethylation450 Array. The environmental factor can be a particular phenotype or environment 
factor from,for example, birth outcomes, maternal conditions or disease traits. The output of GEM_Emodel
for particular environmental factor is a list of CpGs that are potential epigenetic biomarkers.
GEM_Emodel runs linear regression like lm (M ~ E + covt), where M is a matrix with methylation data,
E is a matrix with environment factor and covt is a matrix with covariates, and all read from the
formatted text data file.
}
\examples{
DATADIR = system.file('extdata',package='GEM')
RESULTDIR = getwd()
env_file = paste(DATADIR, "env.txt", sep = .Platform$file.sep)
covariate_file = paste(DATADIR, "cov.txt", sep = .Platform$file.sep)
methylation_file = paste(DATADIR, "methylation.txt", sep = .Platform$file.sep)
Emodel_pv = 1
output_file = paste(RESULTDIR, "Result_Emodel.txt", sep = .Platform$file.sep)
qqplot_file = paste(RESULTDIR, "QQplot_Emodel.jpg", sep = .Platform$file.sep)
GEM_Emodel(env_file, covariate_file, methylation_file, Emodel_pv, output_file, qqplot_file)
}

