% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchFeatures.R
\name{searchFeatures}
\alias{searchFeatures}
\title{searchFeatures function}
\usage{
searchFeatures(host, featureSetId, name = NA_character_,
  geneSymbol = NA_character_, parentId = NA_character_,
  referenceName = NA_character_, start = NA_integer_, end = NA_integer_,
  featureTypes = character(), nrows = Inf, responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{featureSetId}{The annotation set to search within. Either featureSetId
or parentId must be non-empty.}

\item{name}{Only returns features with this name
(case-sensitive, exact match).}

\item{geneSymbol}{Only return features with matching the provided gene symbol
(case-sensitive, exact match). This field may be replaced with a more generic
representation in a future version.}

\item{parentId}{Restricts the search to direct children of the given parent
feature ID. Either feature_set_id or parent_id must be non-empty.}

\item{referenceName}{Only return features on the reference with this name
(matched to literal reference name as imported from the GFF3).}

\item{start}{Required, if name or symbol not provided. The beginning of the
window (0-based, inclusive) for which overlapping features should be
returned. Genomic positions are non-negative integers less than reference
length. Requests spanning the join of circular genomes are represented as two
requests one on each side of the join (position 0).}

\item{end}{Required, if name or symbol not provided. The end of the window
(0-based, exclusive) for which overlapping features should be returned.}

\item{featureTypes}{TODO: To be replaced with a fully featured ontology
search once the Metadata definitions are rounded out. If specified, this
query matches only annotations whose feature_type matches one of the provided
ontology terms.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Search for features (lines of genomic feature files).
}
\details{
This function requests \code{POST host/features/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
featureSetId <- searchFeatureSets(host, datasetId, nrows = 1)$id
searchFeatures(host, featureSetId, nrows = 10)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/sequence_annotation_service.proto.html#SearchFeatures}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{getFeature}}
}
