% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCallSet.R
\name{getCallSet}
\alias{getCallSet}
\title{getCallSet function}
\usage{
getCallSet(host, callSetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{callSetId}{The ID of the CallSet to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a call set by its ID.
}
\details{
This request maps to \code{GET host/callsets/callSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
callSetId <- searchCallSets(host, variantSetId, nrows = 1)$id
getCallSet(host, callSetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/variant_service.proto.html#GetCallSet}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchCallSets}}
}
