% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSNVImpact.R
\name{plotSNVImpact}
\alias{plotSNVImpact}
\title{Plot the Impact of SNVs on G4Hunter Scores}
\usage{
plotSNVImpact(gr, p_colors = c("#b22d2d", "#6ca4d6", "#2d69b0", "#1f77b4"))
}
\arguments{
\item{gr}{A \code{GRanges} object containing the G4Hunter scores and
associated metadata. The object should include the following columns:
\itemize{
  \item \code{G4.info.score}: Numeric vector of the original G4Hunter
  scores.
  \item \code{mut.score}: Numeric vector of the G4Hunter scores after
  mutation.
  \item \code{score.diff}: Numeric vector of the differences between the
  original and mutant G4Hunter scores.
}}

\item{p_colors}{A vector of four colors used for plotting.}
}
\value{
A combined plot (using \code{plot_grid}) containing two subplots:
        - Density scatter plot comparing original vs mutant G4Hunter scores.
        - Density plot of the G4Hunter score differences.
}
\description{
This function is deprecated and will be removed in a future version.
}
\details{
This function generates two plots for visualizing the impact of SNVs on
G4 formation:
1. A scatter plot with density shading comparing the original G4Hunter score
and the mutant G4Hunter score.
2. A density plot showing the distribution of score changes between the
original and mutant G4 sequences.
}
\section{Deprecated}{

This function is no longer supported.
Use \code{\link{plotVarImpact}} instead.
}

\examples{

if (!requireNamespace("BiocManager", quietly = TRUE)) {
  install.packages("BiocManager")
}

if (!requireNamespace("GenomicRanges", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

if (!requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)) {
  BiocManager::install("BSgenome.Hsapiens.UCSC.hg19")
}

library(GenomicRanges)
library(BSgenome.Hsapiens.UCSC.hg19)

hg19 <- BSgenome.Hsapiens.UCSC.hg19
chr21_seq <- DNAStringSet(hg19$chr21)
# Chromosome name is needed
names(chr21_seq) <- "chr21"

G4 <- G4HunterDetect(chr21_seq)

# Load SNVs
data(snp_gr)

res_snp <- SNVImpactG4(G4, snp_gr, alt_col = "alt")
plotSNVImpact(res_snp)
}
\seealso{
\code{\link{SNVImpactG4}} for evaluating the impact of SNVs on G4
formation, and \code{\link{filterSNVImpact}} for filtering G4s that are
significantly affected by SNVs.
}
