% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreFunctions.R
\name{normaliseData}
\alias{normaliseData}
\title{Normalise Marker Intensities}
\usage{
normaliseData(data, markers, method = "none", cofactor = 5)
}
\arguments{
\item{data}{the raw intensity scores.}

\item{markers}{the markers of interest.}

\item{method}{the normalizaton method}

\item{cofactor}{the cofactor for arsinh normalisation}
}
\value{
normalised matrix.
}
\description{
The matrix of intensities is normalised based on one of four different method
These methods include Percentile, zscore, arsinh and minmax
}
\examples{
data("risom_dat")
risomMarkers <- c(
  "CD45", "SMA", "CK7", "CK5", "VIM", "CD31", "PanKRT", "ECAD"
)
normaliseData(risom_dat[, risomMarkers])

}
\author{
Elijah WIllie \href{mailto:ewil3501@uni.sydney.edu.au}{ewil3501@uni.sydney.edu.au}
}
