% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_metaClustering.R
\name{UpdateMetaclusters}
\alias{UpdateMetaclusters}
\title{UpdateMetaclusters}
\usage{
UpdateMetaclusters(
  fsom,
  newLabels = NULL,
  clusterAssignment = NULL,
  levelOrder = NULL
)
}
\arguments{
\item{fsom}{Result of calling the FlowSOM function.}

\item{newLabels}{Optional. Named vector, with the names the original 
metacluster names and the values the replacement. Can be 
used to rename or merge metaclusters.}

\item{clusterAssignment}{Optional. Either a named vector, with the names 
the cluster numbers (characters) or a vector of 
length NClusters(fsom). Can be used to assign 
clusters to existing or new metaclusters.}

\item{levelOrder}{Optional. Vector showing the preferred order of the fsom 
metacluster levels.}
}
\value{
Updated FlowSOM object
}
\description{
Adapt the metacluster levels. Can be used to rename the metaclusters, split 
or merge existing metaclusters, add a metaclustering and/or reorder the levels 
of the metaclustering.
}
\examples{
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
flowSOM.res <- FlowSOM(ff,
                       scale = TRUE,
                       colsToUse = c(9, 12, 14:18), 
                       nClus = 10,
                       seed = 1)
                       
PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering)
GetCounts(flowSOM.res)

# Merge MC8 and MC9
flowSOM.res <- UpdateMetaclusters(flowSOM.res, newLabels = c("8" = "8+9",
                                                             "9" = "8+9")) 
PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering)
GetCounts(flowSOM.res)

# Split cluster 24 from metacluster 2 and order the metacluster levels
flowSOM.res <- UpdateMetaclusters(flowSOM.res, 
                                  clusterAssignment = c("24" = "debris?"),
                                  levelOrder = c("debris?", as.character(c(1:7)),
                                                  "8+9", "10"))
PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering)
PlotNumbers(flowSOM.res, level = "metaclusters")

GetCounts(flowSOM.res)

}
