% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_deprecated.R
\name{PlotClusters2D}
\alias{PlotClusters2D}
\title{PlotClusters2D}
\usage{
PlotClusters2D(
  fsom,
  marker1,
  marker2,
  nodes,
  col = "#FF0000",
  maxBgPoints = 10000,
  pchBackground = ".",
  pchCluster = ".",
  main = "",
  xlab = fsom$prettyColnames[marker1],
  ylab = fsom$prettyColnames[marker2],
  xlim = c(min(fsom$data[, marker1]), max(fsom$data[, marker1])),
  ylim = c(min(fsom$data[, marker2]), max(fsom$data[, marker2])),
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{marker1}{Marker to plot on the x-axis}

\item{marker2}{Marker to plot on the y-axis}

\item{nodes}{Nodes of which the cells should be plotted in red}

\item{col}{Colors for all the cells in the selected nodes (ordered array)}

\item{maxBgPoints}{Maximum number of background points to plot}

\item{pchBackground}{Character to use for background cells}

\item{pchCluster}{Character to use for cells in cluster}

\item{main}{Title of the plot}

\item{xlab}{Label for the x axis}

\item{ylab}{Label for the y axis}

\item{xlim}{Limits for the x axis}

\item{ylim}{Limits for the y axis}

\item{...}{Other parameters to pass on to plot}
}
\value{
Nothing is returned. A plot is drawn in which all cells are plotted
        in black and the cells of the selected nodes in red.
}
\description{
Plot nodes on scatter plot
}
\details{
Plot a 2D scatter plot. All cells of fsom$data are plotted in
black, and those of the selected nodes are plotted in red.
The nodes in the grid are indexed starting from the left bottom,
first going right, then up. E.g. In a 10x10 grid, the node at
top left will have index 91.
}
\examples{

   ## Deprecated - use Plot2DScatters instead ##
 
   # Read from file, build self-organizing map and minimal spanning tree
   fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
   flowSOM.res <- ReadInput(fileName, compensate = TRUE, transform = TRUE,
                            scale = TRUE)
   flowSOM.res <- BuildSOM(flowSOM.res, colsToUse = c(9, 12, 14:18))
  flowSOM.res <- BuildMST(flowSOM.res)
   
   # Plot cells
   \dontrun{
   Plot2DScatters(flowSOM.res, c(1, 2), clusters = 91)
   }

}
\seealso{
\code{\link{PlotNumbers}}, \code{\link{PlotCenters}},
         \code{\link{BuildMST}}
}
