% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_metaClustering.R
\name{FMeasure}
\alias{FMeasure}
\title{F measure}
\usage{
FMeasure(realClusters, predictedClusters, silent = FALSE)
}
\arguments{
\item{realClusters}{Array containing real cluster labels for each sample}

\item{predictedClusters}{Array containing predicted cluster labels for each
sample}

\item{silent}{Logical, if FALSE (default), print some information about 
precision and recall}
}
\value{
F measure score
}
\description{
Compute the F measure between two clustering results
}
\examples{
# Generate some random data as an example
realClusters <- sample(1:5,100,replace = TRUE)
predictedClusters <- sample(1:6, 100, replace = TRUE)

# Calculate the FMeasure
FMeasure(realClusters,predictedClusters)
}
