% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateInfo.R
\name{integrate_ChIP_RNA}
\alias{integrate_ChIP_RNA}
\title{integrate_ChIP_RNA}
\usage{
integrate_ChIP_RNA(
  result_geneRP,
  result_geneDiff,
  lfc_threshold = 1,
  padj_threshold = 0.05
)
}
\arguments{
\item{result_geneRP}{the simplify result from calcRP_TFHit(report_fullInfo = FALSE) or
RP_df <- metadata(fullRP_hit)$peakRP_gene.}

\item{result_geneDiff}{the result from RNA diff result with three column gene_id,
log2FoldChange, padj}

\item{lfc_threshold}{the threshold which decide significant genes}

\item{padj_threshold}{the threshold which decide significant genes}
}
\value{
a ggplot object if having significant genes in your result. If not, it
will report a data.frame with integrated info.
}
\description{
integrate ChIP-Seq and RNA-Seq data to find TF target genes
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    data("RNADiff_LEC2_GR")
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    mmAnno <- mm_geneScan(peak_GR, Txdb)

    result_geneRP <- calcRP_TFHit(
        mmAnno = mmAnno,
        Txdb = Txdb
    )
    # output a plot
    merge_data <- integrate_ChIP_RNA(
        result_geneRP = result_geneRP,
        result_geneDiff = RNADiff_LEC2_GR
    )
    # if you want to extract merge target data
    target_data <- merge_data$data

}
}
