% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_influential_TF.R
\name{findIT_TFHit}
\alias{findIT_TFHit}
\title{findI(nfluential)T(F)_TFHit}
\usage{
findIT_TFHit(
  input_genes,
  Txdb,
  TF_GR_database,
  scan_dist = 20000,
  decay_dist = 1000,
  Chrs_included,
  background_genes = NULL,
  background_number = 3000,
  verbose = TRUE
)
}
\arguments{
\item{input_genes}{a character vector which represent genes set
which you want to find influential TF for}

\item{Txdb}{Txdb}

\item{TF_GR_database}{TF peak GRange with a column named TF_id representing you TF name}

\item{scan_dist}{scan distance}

\item{decay_dist}{decay distance}

\item{Chrs_included}{a character vector represent chromosomes
which you want to sample background genes from}

\item{background_genes}{a character vector which represent background genes set.
If you do not assign background gene , program will sample
background_number genes as background genes from all gene sets.}

\item{background_number}{background genes number}

\item{verbose}{whether you want to report detailed running message}
}
\value{
data.frame
}
\description{
find influential TF of your input gene set based on TF ChIP-Seq or motif data
}
\examples{

if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    data("test_geneSet")
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))

    ChIP_peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    ChIP_peak_GR <- loadPeakFile(ChIP_peak_path)
    ChIP_peak_GR$TF_id <- "AT1G28300"

    set.seed(20160806)
    result_findIT_TFHit <- findIT_TFHit(
        input_genes = test_geneSet,
        Txdb = Txdb,
        TF_GR_database = ChIP_peak_GR
    )

}
}
