% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcRP.R
\name{calcRP_coverage}
\alias{calcRP_coverage}
\title{calcRP_coverage}
\usage{
calcRP_coverage(
  bwFile,
  Txdb,
  gene_included,
  Chrs_included,
  decay_dist = 1000,
  scan_dist = 20000,
  verbose = TRUE
)
}
\arguments{
\item{bwFile}{bw file}

\item{Txdb}{Txdb}

\item{gene_included}{a character vector which represent gene set
which you want to calculate RP for}

\item{Chrs_included}{a character vector which represent chromosomes
where you want to calculate gene RP in}

\item{decay_dist}{decay distance}

\item{scan_dist}{scan distance}

\item{verbose}{whether you want to report detailed running message}
}
\value{
data.frame
}
\description{
calculate regulatory potential using big wig files, which is useful for ATAC
or H3K27ac histone modification data.
}
\details{
Please note that because of rtracklayer::import has some issue on 32 bit R of windows, so the
calcRP_coverage can not work on this system. But if your R is 64 bit,
which now be applied on the most windows R, this function still work.
}
\examples{
if (.Platform$OS.type != "windows" & require(TxDb.Athaliana.BioMart.plantsmart28)) {
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    bwFile <- system.file("extdata", "E50h_sampleChr5.bw", package = "FindIT2")

    RP_df <- calcRP_coverage(
        bwFile = bwFile,
        Txdb = Txdb,
        Chrs_included = "Chr5"
    )

}
}
