#' scMixology short-read gene counts - sample 1
#'
#' Short-read single cell RNA-seq profiling of 
#' human lung adenocarcinoma cell lines using 10X version 
#' 2 chemstry. Single cells from five human lung adenocarcinoma
#' cell lines (H2228, H1975, A549, H838 and HCC827) were mixed 
#' in equal proportions and processed using the Chromium 10X platform, 
#' then sequenced using Illumina HiSeq 2500. See
#' Tian L, Dong X, Freytag S, Lê Cao KA et al. 
#' Benchmarking single cell RNA-sequencing analysis pipelines using
#' mixture control experiments. Nat Methods 2019 Jun;16(6):479-487. PMID: 31133762
#'
#'
#' @format ## `scmixology_lib90`
#' A \code{SingleCellExperiment}
#' @returns A \code{SingleCellExperiment} object
#' @source <https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE126906>
"scmixology_lib90"

#' scMixology short-read gene counts - sample 2
#'
#' Short-read gene counts from long and short-read single 
#' cell RNA-seq profiling of human  lung adenocarcinoma cell 
#' lines using 10X version 2 chemstry. See
#' Tian, L. et al. Comprehensive characterization of single-cell
#' full-length isoforms in human and mouse with long-read sequencing.
#' Genome Biology 22, 310 (2021).
#' 
#'
#' @format ## `scmixology_lib10`
#' A \code{SingleCellExperiment} with 7,240 rows and 60 columns:
#' @returns A \code{SingleCellExperiment} object
#' @source <https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE154869>
"scmixology_lib10"


#' scMixology long-read transcript counts - sample 2
#'
#' long-read transcript counts from long and short-read single 
#' cell RNA-seq profiling of human  lung adenocarcinoma cell 
#' lines using 10X version 2 chemstry. See
#' Tian, L. et al. Comprehensive characterization of single-cell
#' full-length isoforms in human and mouse with long-read sequencing.
#' Genome Biology 22, 310 (2021).
#'
#' @format ## `scmixology_lib10_transcripts`
#' A \code{SingleCellExperiment} with 7,240 rows and 60 columns:
#' @returns A \code{SingleCellExperiment} object
#' @source <https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE154869>
"scmixology_lib10_transcripts"
