% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SingleCellPipeline.R
\name{create_se_from_dir}
\alias{create_se_from_dir}
\title{Create \code{SummarizedExperiment} object from \code{FLAMES} output folder}
\usage{
create_se_from_dir(outdir, annotation, quantification = "FLAMES")
}
\arguments{
\item{outdir}{The folder containing \code{FLAMES} output files}

\item{annotation}{(Optional) the annotation file that was used to produce the output files}

\item{quantification}{(Optional)  the quantification method used to generate the
output files (either "FLAMES" or "Oarfish".). If not specified, the function will
attempt to determine the quantification method.}
}
\value{
a \code{SummarizedExperiment} object
}
\description{
Create \code{SummarizedExperiment} object from \code{FLAMES} output folder
}
\examples{
ppl <- example_pipeline("BulkPipeline")
ppl <- run_FLAMES(ppl)
se1 <- experiment(ppl)
se2 <- create_se_from_dir(ppl@outdir, ppl@annotation)
}
