% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{getSubsetAssay}
\alias{getSubsetAssay}
\alias{getSubsetAssay,SubsetRangedSummarizedExperiment,character-method}
\alias{getSubsetAssay,SubsetSingleCellExperiment,character-method}
\alias{getSubsetAssay,SubsetSummarizedExperiment,character-method}
\alias{getSubsetAssay,SubsetSpatialExperiment,character-method}
\alias{getSubsetAssay,SubsetTreeSummarizedExperiment,character-method}
\title{Get subset assay from an \code{ExperimentSubset} object.}
\usage{
getSubsetAssay(x, subsetName)

\S4method{getSubsetAssay}{SubsetRangedSummarizedExperiment,character}(x, subsetName)

\S4method{getSubsetAssay}{SubsetSingleCellExperiment,character}(x, subsetName)

\S4method{getSubsetAssay}{SubsetSummarizedExperiment,character}(x, subsetName)

\S4method{getSubsetAssay}{SubsetSpatialExperiment,character}(x, subsetName)

\S4method{getSubsetAssay}{SubsetTreeSummarizedExperiment,character}(x, subsetName)
}
\arguments{
\item{x}{Input \code{ExperimentSubset} object.}

\item{subsetName}{Specify 'subset name' or 'subset assay name' to fetch the
assay from.}
}
\value{
Subset assay
}
\description{
Get subset assay from an \code{ExperimentSubset} object.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
getSubsetAssay(es, "subset1")
}
