% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ranges-helpers.R
\name{rescale}
\alias{rescale}
\alias{rescale,IRanges-method}
\alias{rescale,IRangesList-method}
\alias{rescale,GRanges-method}
\alias{rescale,GRangesList-method}
\title{Rescaling \code{Ranges} object}
\usage{
rescale(x, to = 1L, from = 1L)

\S4method{rescale}{IRanges}(x, to = 1L, from = 1L)

\S4method{rescale}{IRangesList}(x, to = 1L, from = 1L)

\S4method{rescale}{GRanges}(x, to = 1L, from = 1L)

\S4method{rescale}{GRangesList}(x, to = 1L, from = 1L)
}
\arguments{
\item{x}{a \code{IRanges}, \code{GRanges}, \code{IRangesList} and
\code{GRangesList} object}

\item{to, from}{an \code{IRanges} object, a \code{character} vector coercible
to \code{IRanges} or a \code{integer} vector parallel to \code{x} or with
\code{length = 1L}.}
}
\value{
an object of the same type and dimensions as \code{x}
}
\description{
\code{rescale()} rescales \code{IRanges}, \code{GRanges}, \code{IRangesList}
and \code{GRangesList} by using minima and maxima derived from \code{to} and
\code{from}.
}
\examples{
x <- IRanges("5-10")
# widen the ranges
rescale(x, 100, 10)
# widen and shift
rescale(x, "31-60", "5-14")
}
\seealso{
\code{\link[IRanges:IRanges-constructor]{IRanges}} for details on
\code{character} vectors coercible to \code{IRanges}.
}
\author{
H. Pagès, F. Ernst
}
