% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGA_Download_Preprocess.R
\name{TCGA_Download_GeneExpression}
\alias{TCGA_Download_GeneExpression}
\title{The TCGA_Download_GeneExpression function}
\usage{
TCGA_Download_GeneExpression(
  CancerSite,
  TargetDirectory,
  mode = "Regular",
  downloadData = TRUE
)
}
\arguments{
\item{CancerSite}{character string indicating the TCGA cancer code.}

\item{TargetDirectory}{character with directory where a folder for downloaded files will be created.}

\item{mode}{character string indicating whether we should download the gene expression data for miRNAs or lncRNAs, instead of for protein-coding genes. See details for more information.}

\item{downloadData}{logical indicating if the data should be downloaded (default: TRUE). If False, the url of the desired data is returned.}
}
\value{
list with paths to downloaded files for gene expression.
}
\description{
Download gene expression data from TCGA.
}
\details{
mode: when mode is set to 'Regular', this function downloads the level 3 RNAseq data (file tag 'mRNAseq_Preprocess.Level_3'). Since there is not enough RNAseq data for OV and GBM, the micro array data is
downloaded. If you plan to run the EpiMix on miRNA- or lncRNA-coding genes, please specify the 'mode' parameter to 'miRNA' or 'lncRNA'.
}
\examples{
\donttest{
# Example #1 : download regular gene expression data for ovarian cancer
GEdirectories <- TCGA_Download_GeneExpression(CancerSite = 'OV', TargetDirectory = tempdir())

# Example #2 : download miRNA expression data for ovarian cancer
GEdirectories <- TCGA_Download_GeneExpression(CancerSite = 'OV',
                                              TargetDirectory = tempdir(),
                                              mode = 'miRNA')

# Example #3 : download lncRNA expression data for ovarian cancer
GEdirectories <- TCGA_Download_GeneExpression(CancerSite = 'OV',
                                               TargetDirectory = tempdir(),
                                               mode = 'lncRNA')
}

}
\keyword{download}
