% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chromHMM.R
\name{plot_chromHMM}
\alias{plot_chromHMM}
\title{Plot ChromHMM heatmap}
\usage{
plot_chromHMM(
  peaklist,
  chromHMM_annotation,
  genome_build,
  cell_line = NULL,
  interact = FALSE,
  return_data = FALSE
)
}
\arguments{
\item{peaklist}{A named \link[base]{list} of peak files as GRanges object.
If list is not named, default names will be assigned.}

\item{chromHMM_annotation}{ChromHMM annotation list.}

\item{genome_build}{The human genome reference build used to generate
peakfiles. "hg19" or "hg38".}

\item{cell_line}{If not \code{cell_line},
will replace \code{chromHMM_annotation}
 by importing chromHMM data for a given cell line using
 \link[EpiCompare]{get_chromHMM_annotation}.}

\item{interact}{Default TRUE. By default, the heatmaps are interactive.
If\code{FALSE}, the function generates a static ChromHMM heatmap.}

\item{return_data}{Return the plot data as in addition to the plot itself.}
}
\value{
ChromHMM heatmap, or a named list.
}
\description{
Creates a heatmap using outputs from ChromHMM using ggplot2.The function
takes a list of peakfiles, performs ChromHMM and outputs a heatmap. ChromHMM
annotation file must be loaded prior to using this function.
ChromHMM annotations are aligned to hg19, and will be automatically lifted
over to the \code{genome_build} to match the build of the \code{peaklist}.
}
\examples{
### Load Data ###
data("CnT_H3K27ac") # example dataset as GRanges object
data("CnR_H3K27ac") # example dataset as GRanges object 
### Create Named Peaklist ###
peaklist <- list(CnT=CnT_H3K27ac, CnR=CnR_H3K27ac) 
### Run ###
my_plot <- plot_chromHMM(peaklist = peaklist,
                         cell_line = "K562",
                         genome_build = "hg19") 
}
