% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragment_info.R
\name{fragment_info}
\alias{fragment_info}
\title{Summary on fragments}
\usage{
fragment_info(picard_list)
}
\arguments{
\item{picard_list}{Named list of duplication metrics generated by Picard
as data frame. Data frames must be named and listed using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}.
To import Picard duplication metrics (.txt file) into R as data frame, use
\code{picard <- read.table("/path/to/picard/output", header = TRUE,
fill = TRUE)}.}
}
\value{
A table summarizing metrics on fragments.
}
\description{
This function outputs a summary on fragments using metrics generated by
Picard. Provides the number of mapped fragments, duplication rate and number
of unique fragments.
}
\examples{
### Load Data ###
data(CnT_H3K27ac_picard) # example picard output
data(CnR_H3K27ac_picard) # example picard output 
### Import Picard Metrics ###
# To import Picard duplication metrics (.txt file) into R as data frame
# CnT_H3K27ac_picard <- read.table("/path/to/picard/output.txt",
#  header = TRUE,fill = TRUE) 
### Create Named List ###
picard_list <- list("CnT_H3K27ac"=CnT_H3K27ac_picard,
               "CnR_H3K27ac"=CnR_H3K27ac_picard) 
df <- fragment_info(picard_list = picard_list)
}
