% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss_plot.R
\name{tss_plot}
\alias{tss_plot}
\title{Read count frequency around TSS}
\usage{
tss_plot(
  peaklist,
  txdb = NULL,
  tss_distance = c(-3000, 3000),
  conf = 0.95,
  resample = 500,
  interact = FALSE,
  workers = check_workers()
)
}
\arguments{
\item{peaklist}{A list of peak files as GRanges object.
Files must be listed and named using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}
If not named, default file names will be assigned.}

\item{txdb}{A TxDb annotation object from Bioconductor.}

\item{tss_distance}{A vector specifying the distance upstream and downstream
around transcription start sites (TSS). 
The default value is \code{c(-3000,3000)}; meaning peak frequency 
3000bp upstream and downstream of TSS will be displayed.}

\item{conf}{Confidence interval threshold estimated by bootstrapping
 (\code{0.95} means 95%).
Argument passed to \link[ChIPseeker]{plotAvgProf}.}

\item{resample}{Number of bootstrapped iterations to run.
Argument passed to \link[ChIPseeker]{plotAvgProf}.}

\item{interact}{Default TRUE. By default, plots are interactive.
If set FALSE, all plots in the report will be static.}

\item{workers}{Number of cores to parallelise bootstrapping across.
Argument passed to \link[ChIPseeker]{plotAvgProf}.}
}
\value{
A named list of profile plots.
}
\description{
This function generates a plot of read count frequency around TSS.
}
\examples{
### Load Data ###
data("CnT_H3K27ac") # example peaklist GRanges object
data("CnR_H3K27ac") # example peaklist GRanges object
### Create Named Peaklist ###
peaklist <- list("CnT"=CnT_H3K27ac, "CnR"=CnR_H3K27ac) 
my_plot <- tss_plot(peaklist = peaklist, 
                    tss_distance=c(-50,50),
                    workers = 1)
}
