% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peak_scores.R
\name{plot_peak_scores}
\alias{plot_peak_scores}
\title{Plot Peak Scores boxplot}
\usage{
plot_peak_scores(
  peaklist,
  score_cols = c("score", "signal.value"),
  interact = FALSE
)
}
\arguments{
\item{peaklist}{A list of peak files as GRanges object.
Files must be named and listed using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}}

\item{score_cols}{Depending on which columns are present, this
value will be used to get peak scores to plot from the metadata columns.}

\item{interact}{Default TRUE. By default, plots are interactive.
If set FALSE, all plots in the report will be static.}
}
\value{
A boxplot of peak scores.
}
\description{
This function creates a boxplot showing the distribution of peak scores in
each peak file.
}
\examples{
data("encode_H3K27ac") # example peaklist GRanges object
data("CnT_H3K27ac") # example peaklist GRanges object
peaklist <- list("encode"=encode_H3K27ac, "CnT"=CnT_H3K27ac)
my_plot <- plot_peak_scores(peaklist = peaklist)
}
