% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CnR_H3K27ac}
\alias{CnR_H3K27ac}
\title{Example CUT&Run peak file}
\format{
An object of class \code{GRanges} of length 2707.
}
\source{
The code to prepare the .Rda file from the raw peak file is:

\code{# sequences were directly downloaded from
 https://trace.ncbi.nlm.nih.gov/Traces/sra/?run=SRR8581604} \cr
\code{# and peaks (BED file) were generated by Leyla Abbasova 
(Neurogenomics Lab, Imperial College London)} \cr
\code{CnR_H3K27ac <- ChIPseeker::readPeakFile("path", as = "GRanges")} \cr
\code{CnR_H3K27ac <- CnR_H3K27ac[seqnames(CnR_H3K27ac)== "chr1"]} \cr
\code{my_label <- 
c("name","score","strand","signalValue","pValue","qValue","peak")}\cr
\code{colnames(GenomicRanges::mcols(CnR_H3K27ac)) <- my_label} \cr
\code{usethis::use_data(CnR_H3K27ac, overwrite = TRUE)} \cr
}
\usage{
data("CnR_H3K27ac")
}
\description{
Human H3K27ac peak file generated with CUT&Run using K562 cell-line from
Meers et al., (2019). Human genome build hg19 was used.
Raw peak file (.BED) was obtained from GEO
(\url{https://trace.ncbi.nlm.nih.gov/Traces/sra/?run=SRR8581604}).
Peak calling was performed by Leyla Abbasova using MACS2.
The peak file was then processed into GRanges object.
Peaks located on chromosome 1 were subsetted to reduce the dataset size.
}
\keyword{datasets}
