% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_gene_scores.R
\name{compute_gene_scores}
\alias{compute_gene_scores}
\title{Compute gene counts}
\usage{
compute_gene_scores(
  sct_data,
  annotLevel,
  bootstrap_list = NULL,
  hits,
  combinedGenes,
  reps = NULL,
  exp_mats = NULL,
  return_hit_exp = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{annotLevel}{An integer indicating which level of \code{sct_data} to
analyse (\emph{Default: 1}).}

\item{bootstrap_list}{The output of \code{get_summed_proportions_iterate}.}

\item{hits}{list of gene names. The target gene set.}

\item{reps}{Number of random gene lists to generate (\emph{Default: 100},
but should be >=10,000 for publication-quality results).}

\item{return_hit_exp}{Return the expression of each hit gene.}

\item{verbose}{Print messages.}
}
\value{
\link[data.table]{data.table}
}
\description{
Aggregate gene-level scores across all bootstrap iterations.
\itemize{
\item{boot: }{Mean specificity of all genes within a given cell type.}
\item{hit: }{Mean specificity of a hit gene within a given cell type.}
}
}
\keyword{internal}
