% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_function.R
\name{getTFtargets}
\alias{getTFtargets}
\title{Get TF target genes}
\usage{
getTFtargets(
  pairs,
  enriched.motif,
  TF.result,
  dmc.analysis,
  mae,
  save = TRUE,
  dir.out = "./",
  classification = "family",
  cores = 1,
  label = NULL
)
}
\arguments{
\item{pairs}{Output of get.pairs function: dataframe or file path}

\item{enriched.motif}{List of probes for each enriched motif: list of file path.
The file created by ELMER is getMotif...enriched.motifs.rda}

\item{TF.result}{Output get.TF function: dataframe or file path}

\item{dmc.analysis}{DMC results file or data frame}

\item{mae}{A multiAssayExperiment outputed from createMAE function}

\item{save}{A logic. If save is true, a files will be saved: getTFtarget.XX..csv
If save is false, only a data frame contains the same content with the first file.}

\item{dir.out}{A path specifies the directory for outputs of get.pair function. Default is current directory}

\item{classification}{use family or subfamily classification to consider potential TF}

\item{cores}{Number of cores to be used in parallel}

\item{label}{A character labels the outputs.}
}
\description{
This function uses ELMER analysis
results and summarizes the possible  genes targets for each TF
}
\examples{
pairs <- data.frame(Probe = c("cg26992600","cg26992800","cg26992900"),
                    Symbol = c("KEAP1","DSP","ATP86"))
enriched.motif <- list("FOXD3_HUMAN.H11MO.0.D"= c("cg26992800","cg26992900"))
TF.result <- data.frame(motif = c("FOXD3_HUMAN.H11MO.0.D"),
                        potential.TF.family = c("TP63;TP73"))
getTFtargets(pairs,enriched.motif,TF.result)

\dontrun{
getTFtargets("../LUAD_LUSC_analysis_hg38/hyper/getPair.hyper.pairs.significant.csv",
enriched.motif = "../LUAD_analysis_hg38/hyper/getMotif.hyper.enriched.motifs.rda",
TF.result = "../LUAD_analysis_hg38/hyper/getTF.hyper.significant.TFs.with.motif.summary.csv")
}
}
